/*
 * Decompiled with CFR 0.152.
 */
package dorkix.armored.elytra;

import dorkix.armored.elytra.ArmoredElytra;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ArmoredElytraClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ArmoredElytraClient");
    public static final Map<String, Float> TRIM_MATERIALS = Map.of("minecraft:quartz", Float.valueOf(0.001f), "minecraft:iron", Float.valueOf(0.002f), "minecraft:netherite", Float.valueOf(0.003f), "minecraft:redstone", Float.valueOf(0.004f), "minecraft:copper", Float.valueOf(0.005f), "minecraft:gold", Float.valueOf(0.006f), "minecraft:emerald", Float.valueOf(0.007f), "minecraft:diamond", Float.valueOf(0.008f), "minecraft:lapis", Float.valueOf(0.009f), "minecraft:amethyst", Float.valueOf(0.01f));
    public static final Map<String, Float> MATERIALS = Map.of("minecraft:leather_chestplate", Float.valueOf(0.1f), "minecraft:chainmail_chestplate", Float.valueOf(0.2f), "minecraft:iron_chestplate", Float.valueOf(0.3f), "minecraft:golden_chestplate", Float.valueOf(0.4f), "minecraft:diamond_chestplate", Float.valueOf(0.5f), "minecraft:netherite_chestplate", Float.valueOf(0.6f));

    public static String getTrimMaterialName(class_2487 armorData) {
        return armorData.method_10562("components").method_10562("minecraft:trim").method_10558("material");
    }

    public static String getMaterialName(class_2487 armorData) {
        return armorData.method_10558("id");
    }

    public static int getColor(class_2487 armorData) {
        int colorRgb = armorData.method_10562("components").method_10562("minecraft:dyed_color").method_10550("rgb");
        if (colorRgb == 0) {
            return -6265536;
        }
        return -16777216 + colorRgb;
    }

    public static float getTrimValue(class_2487 armorData) {
        return TRIM_MATERIALS.getOrDefault(ArmoredElytraClient.getTrimMaterialName(armorData), Float.valueOf(0.0f)).floatValue();
    }

    public static float getMaterialValue(class_2487 armorData) {
        return MATERIALS.getOrDefault(ArmoredElytraClient.getMaterialName(armorData), Float.valueOf(0.0f)).floatValue();
    }

    public void onInitializeClient() {
        class_5272.method_27879((class_1792)class_1802.field_8833, (class_2960)class_2960.method_60654((String)"armored"), (stack, world, ent, i) -> {
            class_2487 customData = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
            class_2487 elytraData = customData.method_10562(ArmoredElytra.ELYTRA_DATA.toString());
            class_2487 armorData = customData.method_10562(ArmoredElytra.CHESTPLATE_DATA.toString());
            if (elytraData.method_33133() || armorData.method_33133()) {
                return 0.0f;
            }
            return ArmoredElytraClient.getMaterialValue(armorData) + ArmoredElytraClient.getTrimValue(armorData);
        });
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 1) {
                return -1;
            }
            class_2487 customData = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
            class_2487 armorData = customData.method_10562(ArmoredElytra.CHESTPLATE_DATA.toString());
            if (armorData.method_33133()) {
                return -1;
            }
            String material = ArmoredElytraClient.getMaterialName(armorData);
            if (!material.equals("minecraft:leather_chestplate")) {
                return -1;
            }
            return ArmoredElytraClient.getColor(armorData);
        }, (Object[])new class_1935[]{class_1802.field_8833});
    }
}

